/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.TargetApi;
import android.os.Build;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cordova.Config;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewClient;
import org.apache.cordova.FileHelper;
import org.apache.cordova.api.CordovaInterface;
import org.apache.cordova.api.LOG;

@TargetApi(value=11)
public class IceCreamCordovaWebViewClient
extends CordovaWebViewClient {
    public IceCreamCordovaWebViewClient(CordovaInterface cordova) {
        super(cordova);
    }

    public IceCreamCordovaWebViewClient(CordovaInterface cordova, CordovaWebView view) {
        super(cordova, view);
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        WebResourceResponse ret = super.shouldInterceptRequest(view, url);
        if (!Config.isUrlWhiteListed(url) && (url.startsWith("http://") || url.startsWith("https://"))) {
            ret = this.getWhitelistResponse();
        } else if (ret == null && (url.contains("?") || url.contains("#") || IceCreamCordovaWebViewClient.needsIceCreamSpecialsInAssetUrlFix(url))) {
            ret = this.generateWebResourceResponse(url);
        } else if (ret == null && this.appView.pluginManager != null) {
            ret = this.appView.pluginManager.shouldInterceptRequest(url);
        }
        return ret;
    }

    private WebResourceResponse getWhitelistResponse() {
        String empty = "";
        ByteArrayInputStream data = new ByteArrayInputStream(empty.getBytes());
        return new WebResourceResponse("text/plain", "UTF-8", (InputStream)data);
    }

    private WebResourceResponse generateWebResourceResponse(String url) {
        if (url.startsWith("file:///android_asset/")) {
            String mimetype = FileHelper.getMimeType(url, this.cordova);
            try {
                InputStream stream = FileHelper.getInputStreamFromUriString(url, this.cordova);
                WebResourceResponse response = new WebResourceResponse(mimetype, "UTF-8", stream);
                return response;
            }
            catch (IOException e) {
                LOG.e("generateWebResourceResponse", e.getMessage(), e);
            }
        }
        return null;
    }

    private static boolean needsIceCreamSpecialsInAssetUrlFix(String url) {
        if (!url.contains("%20")) {
            return false;
        }
        switch (Build.VERSION.SDK_INT) {
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }
}

